/////////////////////////////////////////////////////////////
// CINEMA SDK : TOOLS																			 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_TOOLDATA_H
#define __C4D_TOOLDATA_H

#include "c4d_basedata.h"

class AtomArray;
class String;
class BaseContainer;
class BaseBitmap;
class BaseDocument;
class BaseObject;
class BaseDraw;
class BaseDrawHelp;
class BaseThread;
class CDialog;
class EditorWindow;
class SubDialog;

struct ControlDisplayStruct
{
	LONG		displaymode;
	Bool		backface_culling;
	Bool		editmode;
	Vector	*vertex_color;
};

class ToolData : public BaseData
{
	friend Bool RegisterToolPlugin(LONG id, const String &str, LONG info, BaseBitmap *icon, const String &help, ToolData *dat);

	private:
		virtual CDialog*	AllocDialog(BaseContainer *bc, CDialog *cd_parent, LONG dlg_id);
		virtual void			FreeDialog(CDialog *cd);
	
	public:
		virtual Bool			InitTool(BaseDocument *doc, BaseContainer &data, BaseThread *bt);
		virtual void			FreeTool(BaseDocument *doc, BaseContainer &data);

		virtual Bool			MouseInput(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, EditorWindow *win, const BaseContainer &msg);
		virtual LONG			GetState(BaseDocument *doc);
		virtual Bool      GetCursorInfo(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, Real x, Real y, BaseContainer &bc);
		virtual LONG      Draw(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, BaseDrawHelp *bh, BaseThread *bt,LONG flags);

		virtual Bool			InitDisplayControl(BaseDocument *doc, BaseContainer &data, BaseDraw *bd, AtomArray *active);
		virtual void			FreeDisplayControl(void);
		virtual Bool			DisplayControl(BaseDocument *doc, BaseObject *op, BaseObject *chainstart, BaseDraw *bd, BaseDrawHelp *bh, ControlDisplayStruct &cds);

		virtual SubDialog*	AllocSubDialog(BaseContainer* bc);
};

Bool RegisterToolPlugin(LONG id, const String &str, LONG info, const String &help, ToolData *dat);
Bool RegisterToolPlugin(LONG id, const String &str, LONG info, BaseBitmap *icon, const String &help, ToolData *dat);
Bool RegisterToolPlugin(LONG id, const String &str, LONG info, String icon, const String &help, ToolData *dat);

#endif
